package io.k8s.api.core.v1


/** Represents a Photon Controller persistent disk resource. */
final case class PhotonPersistentDiskVolumeSource(
  fsType : Option[String] = None,
  pdID : String
) {
  def withFsType(value: String) : PhotonPersistentDiskVolumeSource = copy(fsType = Some(value))
  def withPdID(value: String) : PhotonPersistentDiskVolumeSource = copy(pdID = value)
}

