package io.k8s.api.core.v1


/** PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes */
final case class PersistentVolumeClaimSpec(
  accessModes : Option[Seq[String]] = None,
  volumeMode : Option[String] = None,
  dataSourceRef : Option[io.k8s.api.core.v1.TypedLocalObjectReference] = None,
  storageClassName : Option[String] = None,
  dataSource : Option[io.k8s.api.core.v1.TypedLocalObjectReference] = None,
  volumeName : Option[String] = None,
  resources : Option[io.k8s.api.core.v1.ResourceRequirements] = None,
  selector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
) {
  def withAccessModes(value: Seq[String]) : PersistentVolumeClaimSpec = copy(accessModes = Some(value))
  def addAccessModes(newValues: String*) : PersistentVolumeClaimSpec = copy(accessModes = Some(accessModes.fold(newValues)(_ ++ newValues)))

  def withVolumeMode(value: String) : PersistentVolumeClaimSpec = copy(volumeMode = Some(value))
  def withDataSourceRef(value: io.k8s.api.core.v1.TypedLocalObjectReference) : PersistentVolumeClaimSpec = copy(dataSourceRef = Some(value))
  def withStorageClassName(value: String) : PersistentVolumeClaimSpec = copy(storageClassName = Some(value))
  def withDataSource(value: io.k8s.api.core.v1.TypedLocalObjectReference) : PersistentVolumeClaimSpec = copy(dataSource = Some(value))
  def withVolumeName(value: String) : PersistentVolumeClaimSpec = copy(volumeName = Some(value))
  def withResources(value: io.k8s.api.core.v1.ResourceRequirements) : PersistentVolumeClaimSpec = copy(resources = Some(value))
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : PersistentVolumeClaimSpec = copy(selector = Some(value))
}

