package io.k8s.api.core.v1


/** PersistentVolumeClaimCondition contails details about state of pvc */
final case class PersistentVolumeClaimCondition(
  lastProbeTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  reason : Option[String] = None,
  status : String,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : String
) {
  def withLastProbeTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PersistentVolumeClaimCondition = copy(lastProbeTime = Some(value))
  def withReason(value: String) : PersistentVolumeClaimCondition = copy(reason = Some(value))
  def withStatus(value: String) : PersistentVolumeClaimCondition = copy(status = value)
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PersistentVolumeClaimCondition = copy(lastTransitionTime = Some(value))
  def withMessage(value: String) : PersistentVolumeClaimCondition = copy(message = Some(value))
  def withType(value: String) : PersistentVolumeClaimCondition = copy(`type` = value)
}

