package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** PersistentVolumeClaim is a user's request for and claim to a persistent volume */
final case class PersistentVolumeClaim(
  status : Option[io.k8s.api.core.v1.PersistentVolumeClaimStatus] = None,
  spec : Option[io.k8s.api.core.v1.PersistentVolumeClaimSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "PersistentVolumeClaim", "v1")

  def withStatus(value: io.k8s.api.core.v1.PersistentVolumeClaimStatus) : PersistentVolumeClaim = copy(status = Some(value))
  def withSpec(value: io.k8s.api.core.v1.PersistentVolumeClaimSpec) : PersistentVolumeClaim = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PersistentVolumeClaim = copy(metadata = Some(value))
}

