package io.k8s.api.core.v1


/** ObjectReference contains enough information to let you inspect or modify the referred object. */
final case class ObjectReference(
  fieldPath : Option[String] = None,
  name : Option[String] = None,
  resourceVersion : Option[String] = None,
  uid : Option[String] = None,
  namespace : Option[String] = None
) {
  def withFieldPath(value: String) : ObjectReference = copy(fieldPath = Some(value))
  def withName(value: String) : ObjectReference = copy(name = Some(value))
  def withResourceVersion(value: String) : ObjectReference = copy(resourceVersion = Some(value))
  def withUid(value: String) : ObjectReference = copy(uid = Some(value))
  def withNamespace(value: String) : ObjectReference = copy(namespace = Some(value))
}

