package io.k8s.api.core.v1


/** NodeSystemInfo is a set of ids/uuids to uniquely identify the node. */
final case class NodeSystemInfo(
  systemUUID : String,
  osImage : String,
  machineID : String,
  bootID : String,
  architecture : String,
  kubeletVersion : String,
  operatingSystem : String,
  kubeProxyVersion : String,
  containerRuntimeVersion : String,
  kernelVersion : String
) {
  def withSystemUUID(value: String) : NodeSystemInfo = copy(systemUUID = value)
  def withOsImage(value: String) : NodeSystemInfo = copy(osImage = value)
  def withMachineID(value: String) : NodeSystemInfo = copy(machineID = value)
  def withBootID(value: String) : NodeSystemInfo = copy(bootID = value)
  def withArchitecture(value: String) : NodeSystemInfo = copy(architecture = value)
  def withKubeletVersion(value: String) : NodeSystemInfo = copy(kubeletVersion = value)
  def withOperatingSystem(value: String) : NodeSystemInfo = copy(operatingSystem = value)
  def withKubeProxyVersion(value: String) : NodeSystemInfo = copy(kubeProxyVersion = value)
  def withContainerRuntimeVersion(value: String) : NodeSystemInfo = copy(containerRuntimeVersion = value)
  def withKernelVersion(value: String) : NodeSystemInfo = copy(kernelVersion = value)
}

