package io.k8s.api.core.v1


/** A null or empty node selector term matches no objects. The requirements of them are ANDed. The TopologySelectorTerm type implements a subset of the NodeSelectorTerm. */
final case class NodeSelectorTerm(
  matchExpressions : Option[Seq[io.k8s.api.core.v1.NodeSelectorRequirement]] = None,
  matchFields : Option[Seq[io.k8s.api.core.v1.NodeSelectorRequirement]] = None
) {
  def withMatchExpressions(value: Seq[io.k8s.api.core.v1.NodeSelectorRequirement]) : NodeSelectorTerm = copy(matchExpressions = Some(value))
  def addMatchExpressions(newValues: io.k8s.api.core.v1.NodeSelectorRequirement*) : NodeSelectorTerm = copy(matchExpressions = Some(matchExpressions.fold(newValues)(_ ++ newValues)))

  def withMatchFields(value: Seq[io.k8s.api.core.v1.NodeSelectorRequirement]) : NodeSelectorTerm = copy(matchFields = Some(value))
  def addMatchFields(newValues: io.k8s.api.core.v1.NodeSelectorRequirement*) : NodeSelectorTerm = copy(matchFields = Some(matchFields.fold(newValues)(_ ++ newValues)))

}

