package io.k8s.api.core.v1


/** A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values. */
final case class NodeSelectorRequirement(
  key : String,
  operator : String,
  values : Option[Seq[String]] = None
) {
  def withKey(value: String) : NodeSelectorRequirement = copy(key = value)
  def withOperator(value: String) : NodeSelectorRequirement = copy(operator = value)
  def withValues(value: Seq[String]) : NodeSelectorRequirement = copy(values = Some(value))
  def addValues(newValues: String*) : NodeSelectorRequirement = copy(values = Some(values.fold(newValues)(_ ++ newValues)))

}

