package io.k8s.api.core.v1


/** A node selector represents the union of the results of one or more label queries over a set of nodes; that is, it represents the OR of the selectors represented by the node selector terms. */
final case class NodeSelector(
  nodeSelectorTerms : Seq[io.k8s.api.core.v1.NodeSelectorTerm]
) {
  def withNodeSelectorTerms(value: Seq[io.k8s.api.core.v1.NodeSelectorTerm]) : NodeSelector = copy(nodeSelectorTerms = value)
  def addNodeSelectorTerms(newValues: io.k8s.api.core.v1.NodeSelectorTerm*) : NodeSelector = copy(nodeSelectorTerms = nodeSelectorTerms ++ newValues)

}

