package io.k8s.api.core.v1


/** NodeConfigStatus describes the status of the config assigned by Node.Spec.ConfigSource. */
final case class NodeConfigStatus(
  active : Option[io.k8s.api.core.v1.NodeConfigSource] = None,
  assigned : Option[io.k8s.api.core.v1.NodeConfigSource] = None,
  error : Option[String] = None,
  lastKnownGood : Option[io.k8s.api.core.v1.NodeConfigSource] = None
) {
  def withActive(value: io.k8s.api.core.v1.NodeConfigSource) : NodeConfigStatus = copy(active = Some(value))
  def withAssigned(value: io.k8s.api.core.v1.NodeConfigSource) : NodeConfigStatus = copy(assigned = Some(value))
  def withError(value: String) : NodeConfigStatus = copy(error = Some(value))
  def withLastKnownGood(value: io.k8s.api.core.v1.NodeConfigSource) : NodeConfigStatus = copy(lastKnownGood = Some(value))
}

