package io.k8s.api.core.v1


/** NodeCondition contains condition information for a node. */
final case class NodeCondition(
  reason : Option[String] = None,
  status : String,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : String,
  lastHeartbeatTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
) {
  def withReason(value: String) : NodeCondition = copy(reason = Some(value))
  def withStatus(value: String) : NodeCondition = copy(status = value)
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : NodeCondition = copy(lastTransitionTime = Some(value))
  def withMessage(value: String) : NodeCondition = copy(message = Some(value))
  def withType(value: String) : NodeCondition = copy(`type` = value)
  def withLastHeartbeatTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : NodeCondition = copy(lastHeartbeatTime = Some(value))
}

