package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** Node is a worker node in Kubernetes. Each node will have a unique identifier in the cache (i.e. in etcd). */
final case class Node(
  status : Option[io.k8s.api.core.v1.NodeStatus] = None,
  spec : Option[io.k8s.api.core.v1.NodeSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "Node", "v1")

  def withStatus(value: io.k8s.api.core.v1.NodeStatus) : Node = copy(status = Some(value))
  def withSpec(value: io.k8s.api.core.v1.NodeSpec) : Node = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Node = copy(metadata = Some(value))
}

