package io.k8s.api.core.v1


/** NamespaceSpec describes the attributes on a Namespace. */
final case class NamespaceSpec(
  finalizers : Option[Seq[String]] = None
) {
  def withFinalizers(value: Seq[String]) : NamespaceSpec = copy(finalizers = Some(value))
  def addFinalizers(newValues: String*) : NamespaceSpec = copy(finalizers = Some(finalizers.fold(newValues)(_ ++ newValues)))

}

