package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** NamespaceList is a list of Namespaces. */
final case class NamespaceList(
  items : Seq[io.k8s.api.core.v1.Namespace],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "NamespaceList", "v1")

  def withItems(value: Seq[io.k8s.api.core.v1.Namespace]) : NamespaceList = copy(items = value)
  def addItems(newValues: io.k8s.api.core.v1.Namespace*) : NamespaceList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : NamespaceList = copy(metadata = Some(value))
}

