package io.k8s.api.core.v1


/** NamespaceCondition contains details about state of namespace. */
final case class NamespaceCondition(
  reason : Option[String] = None,
  status : String,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : String
) {
  def withReason(value: String) : NamespaceCondition = copy(reason = Some(value))
  def withStatus(value: String) : NamespaceCondition = copy(status = value)
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : NamespaceCondition = copy(lastTransitionTime = Some(value))
  def withMessage(value: String) : NamespaceCondition = copy(message = Some(value))
  def withType(value: String) : NamespaceCondition = copy(`type` = value)
}

