package io.k8s.api.core.v1


/** Local represents directly-attached storage with node affinity (Beta feature) */
final case class LocalVolumeSource(
  fsType : Option[String] = None,
  path : String
) {
  def withFsType(value: String) : LocalVolumeSource = copy(fsType = Some(value))
  def withPath(value: String) : LocalVolumeSource = copy(path = value)
}

