package io.k8s.api.core.v1


/** LoadBalancerIngress represents the status of a load-balancer ingress point: traffic intended for the service should be sent to an ingress point. */
final case class LoadBalancerIngress(
  hostname : Option[String] = None,
  ip : Option[String] = None,
  ports : Option[Seq[io.k8s.api.core.v1.PortStatus]] = None
) {
  def withHostname(value: String) : LoadBalancerIngress = copy(hostname = Some(value))
  def withIp(value: String) : LoadBalancerIngress = copy(ip = Some(value))
  def withPorts(value: Seq[io.k8s.api.core.v1.PortStatus]) : LoadBalancerIngress = copy(ports = Some(value))
  def addPorts(newValues: io.k8s.api.core.v1.PortStatus*) : LoadBalancerIngress = copy(ports = Some(ports.fold(newValues)(_ ++ newValues)))

}

