package io.k8s.api.core.v1


/** LimitRangeSpec defines a min/max usage limit for resources that match on kind. */
final case class LimitRangeSpec(
  limits : Seq[io.k8s.api.core.v1.LimitRangeItem]
) {
  def withLimits(value: Seq[io.k8s.api.core.v1.LimitRangeItem]) : LimitRangeSpec = copy(limits = value)
  def addLimits(newValues: io.k8s.api.core.v1.LimitRangeItem*) : LimitRangeSpec = copy(limits = limits ++ newValues)

}

