package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** LimitRangeList is a list of LimitRange items. */
final case class LimitRangeList(
  items : Seq[io.k8s.api.core.v1.LimitRange],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "LimitRangeList", "v1")

  def withItems(value: Seq[io.k8s.api.core.v1.LimitRange]) : LimitRangeList = copy(items = value)
  def addItems(newValues: io.k8s.api.core.v1.LimitRange*) : LimitRangeList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : LimitRangeList = copy(metadata = Some(value))
}

