package io.k8s.api.core.v1


/** LimitRangeItem defines a min/max usage limit for any resource that matches on kind. */
final case class LimitRangeItem(
  defaultRequest : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  min : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  maxLimitRequestRatio : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  max : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  default : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  `type` : String
) {
  def withDefaultRequest(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : LimitRangeItem = copy(defaultRequest = Some(value))
  def addDefaultRequest(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : LimitRangeItem = copy(defaultRequest = Some(defaultRequest.fold(newValues.toMap)(_ ++ newValues)))

  def withMin(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : LimitRangeItem = copy(min = Some(value))
  def addMin(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : LimitRangeItem = copy(min = Some(min.fold(newValues.toMap)(_ ++ newValues)))

  def withMaxLimitRequestRatio(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : LimitRangeItem = copy(maxLimitRequestRatio = Some(value))
  def addMaxLimitRequestRatio(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : LimitRangeItem = copy(maxLimitRequestRatio = Some(maxLimitRequestRatio.fold(newValues.toMap)(_ ++ newValues)))

  def withMax(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : LimitRangeItem = copy(max = Some(value))
  def addMax(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : LimitRangeItem = copy(max = Some(max.fold(newValues.toMap)(_ ++ newValues)))

  def withDefault(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : LimitRangeItem = copy(default = Some(value))
  def addDefault(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : LimitRangeItem = copy(default = Some(default.fold(newValues.toMap)(_ ++ newValues)))

  def withType(value: String) : LimitRangeItem = copy(`type` = value)
}

