package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** LimitRange sets resource usage limits for each kind of resource in a Namespace. */
final case class LimitRange(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.core.v1.LimitRangeSpec] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "LimitRange", "v1")

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : LimitRange = copy(metadata = Some(value))
  def withSpec(value: io.k8s.api.core.v1.LimitRangeSpec) : LimitRange = copy(spec = Some(value))
}

