package io.k8s.api.core.v1


/** LifecycleHandler defines a specific action that should be taken in a lifecycle hook. One and only one of the fields, except TCPSocket must be specified. */
final case class LifecycleHandler(
  exec : Option[io.k8s.api.core.v1.ExecAction] = None,
  httpGet : Option[io.k8s.api.core.v1.HTTPGetAction] = None,
  tcpSocket : Option[io.k8s.api.core.v1.TCPSocketAction] = None
) {
  def withExec(value: io.k8s.api.core.v1.ExecAction) : LifecycleHandler = copy(exec = Some(value))
  def withHttpGet(value: io.k8s.api.core.v1.HTTPGetAction) : LifecycleHandler = copy(httpGet = Some(value))
  def withTcpSocket(value: io.k8s.api.core.v1.TCPSocketAction) : LifecycleHandler = copy(tcpSocket = Some(value))
}

