package io.k8s.api.core.v1


/** Represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling. */
final case class ISCSIVolumeSource(
  portals : Option[Seq[String]] = None,
  readOnly : Option[Boolean] = None,
  chapAuthDiscovery : Option[Boolean] = None,
  fsType : Option[String] = None,
  secretRef : Option[io.k8s.api.core.v1.LocalObjectReference] = None,
  iqn : String,
  initiatorName : Option[String] = None,
  iscsiInterface : Option[String] = None,
  targetPortal : String,
  lun : Int,
  chapAuthSession : Option[Boolean] = None
) {
  def withPortals(value: Seq[String]) : ISCSIVolumeSource = copy(portals = Some(value))
  def addPortals(newValues: String*) : ISCSIVolumeSource = copy(portals = Some(portals.fold(newValues)(_ ++ newValues)))

  def withReadOnly(value: Boolean) : ISCSIVolumeSource = copy(readOnly = Some(value))
  def withChapAuthDiscovery(value: Boolean) : ISCSIVolumeSource = copy(chapAuthDiscovery = Some(value))
  def withFsType(value: String) : ISCSIVolumeSource = copy(fsType = Some(value))
  def withSecretRef(value: io.k8s.api.core.v1.LocalObjectReference) : ISCSIVolumeSource = copy(secretRef = Some(value))
  def withIqn(value: String) : ISCSIVolumeSource = copy(iqn = value)
  def withInitiatorName(value: String) : ISCSIVolumeSource = copy(initiatorName = Some(value))
  def withIscsiInterface(value: String) : ISCSIVolumeSource = copy(iscsiInterface = Some(value))
  def withTargetPortal(value: String) : ISCSIVolumeSource = copy(targetPortal = value)
  def withLun(value: Int) : ISCSIVolumeSource = copy(lun = value)
  def withChapAuthSession(value: Boolean) : ISCSIVolumeSource = copy(chapAuthSession = Some(value))
}

