package io.k8s.api.core.v1


/** HTTPHeader describes a custom header to be used in HTTP probes */
final case class HTTPHeader(
  name : String,
  value : String
) {
  def withName(value: String) : HTTPHeader = copy(name = value)
  def withValue(value: String) : HTTPHeader = copy(value = value)
}

