package io.k8s.api.core.v1


/** HTTPGetAction describes an action based on HTTP Get requests. */
final case class HTTPGetAction(
  path : Option[String] = None,
  host : Option[String] = None,
  port : io.k8s.apimachinery.pkg.util.intstr.IntOrString,
  scheme : Option[String] = None,
  httpHeaders : Option[Seq[io.k8s.api.core.v1.HTTPHeader]] = None
) {
  def withPath(value: String) : HTTPGetAction = copy(path = Some(value))
  def withHost(value: String) : HTTPGetAction = copy(host = Some(value))
  def withPort(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : HTTPGetAction = copy(port = value)
  def withScheme(value: String) : HTTPGetAction = copy(scheme = Some(value))
  def withHttpHeaders(value: Seq[io.k8s.api.core.v1.HTTPHeader]) : HTTPGetAction = copy(httpHeaders = Some(value))
  def addHttpHeaders(newValues: io.k8s.api.core.v1.HTTPHeader*) : HTTPGetAction = copy(httpHeaders = Some(httpHeaders.fold(newValues)(_ ++ newValues)))

}

