package io.k8s.api.core.v1


/** Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling. */
final case class GlusterfsPersistentVolumeSource(
  endpoints : String,
  endpointsNamespace : Option[String] = None,
  path : String,
  readOnly : Option[Boolean] = None
) {
  def withEndpoints(value: String) : GlusterfsPersistentVolumeSource = copy(endpoints = value)
  def withEndpointsNamespace(value: String) : GlusterfsPersistentVolumeSource = copy(endpointsNamespace = Some(value))
  def withPath(value: String) : GlusterfsPersistentVolumeSource = copy(path = value)
  def withReadOnly(value: Boolean) : GlusterfsPersistentVolumeSource = copy(readOnly = Some(value))
}

