package io.k8s.api.core.v1


/** Represents a volume that is populated with the contents of a git repository. Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.

DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container. */
final case class GitRepoVolumeSource(
  directory : Option[String] = None,
  repository : String,
  revision : Option[String] = None
) {
  def withDirectory(value: String) : GitRepoVolumeSource = copy(directory = Some(value))
  def withRepository(value: String) : GitRepoVolumeSource = copy(repository = value)
  def withRevision(value: String) : GitRepoVolumeSource = copy(revision = Some(value))
}

