package io.k8s.api.core.v1


/** Represents a Persistent Disk resource in Google Compute Engine.

A GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling. */
final case class GCEPersistentDiskVolumeSource(
  fsType : Option[String] = None,
  partition : Option[Int] = None,
  pdName : String,
  readOnly : Option[Boolean] = None
) {
  def withFsType(value: String) : GCEPersistentDiskVolumeSource = copy(fsType = Some(value))
  def withPartition(value: Int) : GCEPersistentDiskVolumeSource = copy(partition = Some(value))
  def withPdName(value: String) : GCEPersistentDiskVolumeSource = copy(pdName = value)
  def withReadOnly(value: Boolean) : GCEPersistentDiskVolumeSource = copy(readOnly = Some(value))
}

