package io.k8s.api.core.v1


/** EventSource contains information for an event. */
final case class EventSource(
  component : Option[String] = None,
  host : Option[String] = None
) {
  def withComponent(value: String) : EventSource = copy(component = Some(value))
  def withHost(value: String) : EventSource = copy(host = Some(value))
}

