package io.k8s.api.core.v1


/** EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time. */
final case class EventSeries(
  count : Option[Int] = None,
  lastObservedTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None
) {
  def withCount(value: Int) : EventSeries = copy(count = Some(value))
  def withLastObservedTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : EventSeries = copy(lastObservedTime = Some(value))
}

