package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** EventList is a list of events. */
final case class EventList(
  items : Seq[io.k8s.api.core.v1.Event],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "EventList", "v1")

  def withItems(value: Seq[io.k8s.api.core.v1.Event]) : EventList = copy(items = value)
  def addItems(newValues: io.k8s.api.core.v1.Event*) : EventList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : EventList = copy(metadata = Some(value))
}

