package io.k8s.api.core.v1


/** An EphemeralContainer is a temporary container that you may add to an existing Pod for user-initiated activities such as debugging. Ephemeral containers have no resource or scheduling guarantees, and they will not be restarted when they exit or when a Pod is removed or restarted. The kubelet may evict a Pod if an ephemeral container causes the Pod to exceed its resource allocation.

To add an ephemeral container, use the ephemeralcontainers subresource of an existing Pod. Ephemeral containers may not be removed or restarted. */
final case class EphemeralContainer(
  readinessProbe : Option[io.k8s.api.core.v1.Probe] = None,
  name : String,
  livenessProbe : Option[io.k8s.api.core.v1.Probe] = None,
  lifecycle : Option[io.k8s.api.core.v1.Lifecycle] = None,
  image : Option[String] = None,
  stdinOnce : Option[Boolean] = None,
  ports : Option[Seq[io.k8s.api.core.v1.ContainerPort]] = None,
  startupProbe : Option[io.k8s.api.core.v1.Probe] = None,
  command : Option[Seq[String]] = None,
  terminationMessagePolicy : Option[String] = None,
  targetContainerName : Option[String] = None,
  stdin : Option[Boolean] = None,
  terminationMessagePath : Option[String] = None,
  resources : Option[io.k8s.api.core.v1.ResourceRequirements] = None,
  envFrom : Option[Seq[io.k8s.api.core.v1.EnvFromSource]] = None,
  volumeDevices : Option[Seq[io.k8s.api.core.v1.VolumeDevice]] = None,
  args : Option[Seq[String]] = None,
  tty : Option[Boolean] = None,
  imagePullPolicy : Option[String] = None,
  workingDir : Option[String] = None,
  volumeMounts : Option[Seq[io.k8s.api.core.v1.VolumeMount]] = None,
  env : Option[Seq[io.k8s.api.core.v1.EnvVar]] = None,
  securityContext : Option[io.k8s.api.core.v1.SecurityContext] = None
) {
  def withReadinessProbe(value: io.k8s.api.core.v1.Probe) : EphemeralContainer = copy(readinessProbe = Some(value))
  def withName(value: String) : EphemeralContainer = copy(name = value)
  def withLivenessProbe(value: io.k8s.api.core.v1.Probe) : EphemeralContainer = copy(livenessProbe = Some(value))
  def withLifecycle(value: io.k8s.api.core.v1.Lifecycle) : EphemeralContainer = copy(lifecycle = Some(value))
  def withImage(value: String) : EphemeralContainer = copy(image = Some(value))
  def withStdinOnce(value: Boolean) : EphemeralContainer = copy(stdinOnce = Some(value))
  def withPorts(value: Seq[io.k8s.api.core.v1.ContainerPort]) : EphemeralContainer = copy(ports = Some(value))
  def addPorts(newValues: io.k8s.api.core.v1.ContainerPort*) : EphemeralContainer = copy(ports = Some(ports.fold(newValues)(_ ++ newValues)))

  def withStartupProbe(value: io.k8s.api.core.v1.Probe) : EphemeralContainer = copy(startupProbe = Some(value))
  def withCommand(value: Seq[String]) : EphemeralContainer = copy(command = Some(value))
  def addCommand(newValues: String*) : EphemeralContainer = copy(command = Some(command.fold(newValues)(_ ++ newValues)))

  def withTerminationMessagePolicy(value: String) : EphemeralContainer = copy(terminationMessagePolicy = Some(value))
  def withTargetContainerName(value: String) : EphemeralContainer = copy(targetContainerName = Some(value))
  def withStdin(value: Boolean) : EphemeralContainer = copy(stdin = Some(value))
  def withTerminationMessagePath(value: String) : EphemeralContainer = copy(terminationMessagePath = Some(value))
  def withResources(value: io.k8s.api.core.v1.ResourceRequirements) : EphemeralContainer = copy(resources = Some(value))
  def withEnvFrom(value: Seq[io.k8s.api.core.v1.EnvFromSource]) : EphemeralContainer = copy(envFrom = Some(value))
  def addEnvFrom(newValues: io.k8s.api.core.v1.EnvFromSource*) : EphemeralContainer = copy(envFrom = Some(envFrom.fold(newValues)(_ ++ newValues)))

  def withVolumeDevices(value: Seq[io.k8s.api.core.v1.VolumeDevice]) : EphemeralContainer = copy(volumeDevices = Some(value))
  def addVolumeDevices(newValues: io.k8s.api.core.v1.VolumeDevice*) : EphemeralContainer = copy(volumeDevices = Some(volumeDevices.fold(newValues)(_ ++ newValues)))

  def withArgs(value: Seq[String]) : EphemeralContainer = copy(args = Some(value))
  def addArgs(newValues: String*) : EphemeralContainer = copy(args = Some(args.fold(newValues)(_ ++ newValues)))

  def withTty(value: Boolean) : EphemeralContainer = copy(tty = Some(value))
  def withImagePullPolicy(value: String) : EphemeralContainer = copy(imagePullPolicy = Some(value))
  def withWorkingDir(value: String) : EphemeralContainer = copy(workingDir = Some(value))
  def withVolumeMounts(value: Seq[io.k8s.api.core.v1.VolumeMount]) : EphemeralContainer = copy(volumeMounts = Some(value))
  def addVolumeMounts(newValues: io.k8s.api.core.v1.VolumeMount*) : EphemeralContainer = copy(volumeMounts = Some(volumeMounts.fold(newValues)(_ ++ newValues)))

  def withEnv(value: Seq[io.k8s.api.core.v1.EnvVar]) : EphemeralContainer = copy(env = Some(value))
  def addEnv(newValues: io.k8s.api.core.v1.EnvVar*) : EphemeralContainer = copy(env = Some(env.fold(newValues)(_ ++ newValues)))

  def withSecurityContext(value: io.k8s.api.core.v1.SecurityContext) : EphemeralContainer = copy(securityContext = Some(value))
}

