package io.k8s.api.core.v1


/** EnvVarSource represents a source for the value of an EnvVar. */
final case class EnvVarSource(
  configMapKeyRef : Option[io.k8s.api.core.v1.ConfigMapKeySelector] = None,
  fieldRef : Option[io.k8s.api.core.v1.ObjectFieldSelector] = None,
  resourceFieldRef : Option[io.k8s.api.core.v1.ResourceFieldSelector] = None,
  secretKeyRef : Option[io.k8s.api.core.v1.SecretKeySelector] = None
) {
  def withConfigMapKeyRef(value: io.k8s.api.core.v1.ConfigMapKeySelector) : EnvVarSource = copy(configMapKeyRef = Some(value))
  def withFieldRef(value: io.k8s.api.core.v1.ObjectFieldSelector) : EnvVarSource = copy(fieldRef = Some(value))
  def withResourceFieldRef(value: io.k8s.api.core.v1.ResourceFieldSelector) : EnvVarSource = copy(resourceFieldRef = Some(value))
  def withSecretKeyRef(value: io.k8s.api.core.v1.SecretKeySelector) : EnvVarSource = copy(secretKeyRef = Some(value))
}

