package io.k8s.api.core.v1


/** EnvFromSource represents the source of a set of ConfigMaps */
final case class EnvFromSource(
  configMapRef : Option[io.k8s.api.core.v1.ConfigMapEnvSource] = None,
  prefix : Option[String] = None,
  secretRef : Option[io.k8s.api.core.v1.SecretEnvSource] = None
) {
  def withConfigMapRef(value: io.k8s.api.core.v1.ConfigMapEnvSource) : EnvFromSource = copy(configMapRef = Some(value))
  def withPrefix(value: String) : EnvFromSource = copy(prefix = Some(value))
  def withSecretRef(value: io.k8s.api.core.v1.SecretEnvSource) : EnvFromSource = copy(secretRef = Some(value))
}

