package io.k8s.api.core.v1


/** EndpointPort is a tuple that describes a single port. */
final case class EndpointPort(
  appProtocol : Option[String] = None,
  name : Option[String] = None,
  port : Int,
  protocol : Option[String] = None
) {
  def withAppProtocol(value: String) : EndpointPort = copy(appProtocol = Some(value))
  def withName(value: String) : EndpointPort = copy(name = Some(value))
  def withPort(value: Int) : EndpointPort = copy(port = value)
  def withProtocol(value: String) : EndpointPort = copy(protocol = Some(value))
}

