package io.k8s.api.core.v1


/** Represents an empty directory for a pod. Empty directory volumes support ownership management and SELinux relabeling. */
final case class EmptyDirVolumeSource(
  medium : Option[String] = None,
  sizeLimit : Option[io.k8s.apimachinery.pkg.api.resource.Quantity] = None
) {
  def withMedium(value: String) : EmptyDirVolumeSource = copy(medium = Some(value))
  def withSizeLimit(value: io.k8s.apimachinery.pkg.api.resource.Quantity) : EmptyDirVolumeSource = copy(sizeLimit = Some(value))
}

