package io.k8s.api.core.v1


/** DownwardAPIVolumeSource represents a volume containing downward API info. Downward API volumes support ownership management and SELinux relabeling. */
final case class DownwardAPIVolumeSource(
  defaultMode : Option[Int] = None,
  items : Option[Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]] = None
) {
  def withDefaultMode(value: Int) : DownwardAPIVolumeSource = copy(defaultMode = Some(value))
  def withItems(value: Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]) : DownwardAPIVolumeSource = copy(items = Some(value))
  def addItems(newValues: io.k8s.api.core.v1.DownwardAPIVolumeFile*) : DownwardAPIVolumeSource = copy(items = Some(items.fold(newValues)(_ ++ newValues)))

}

