package io.k8s.api.core.v1


/** ContainerStateWaiting is a waiting state of a container. */
final case class ContainerStateWaiting(
  message : Option[String] = None,
  reason : Option[String] = None
) {
  def withMessage(value: String) : ContainerStateWaiting = copy(message = Some(value))
  def withReason(value: String) : ContainerStateWaiting = copy(reason = Some(value))
}

