package io.k8s.api.core.v1


/** ContainerStateTerminated is a terminated state of a container. */
final case class ContainerStateTerminated(
  exitCode : Int,
  reason : Option[String] = None,
  startedAt : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  finishedAt : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  containerID : Option[String] = None,
  signal : Option[Int] = None
) {
  def withExitCode(value: Int) : ContainerStateTerminated = copy(exitCode = value)
  def withReason(value: String) : ContainerStateTerminated = copy(reason = Some(value))
  def withStartedAt(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ContainerStateTerminated = copy(startedAt = Some(value))
  def withMessage(value: String) : ContainerStateTerminated = copy(message = Some(value))
  def withFinishedAt(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ContainerStateTerminated = copy(finishedAt = Some(value))
  def withContainerID(value: String) : ContainerStateTerminated = copy(containerID = Some(value))
  def withSignal(value: Int) : ContainerStateTerminated = copy(signal = Some(value))
}

