package io.k8s.api.core.v1


/** ContainerPort represents a network port in a single container. */
final case class ContainerPort(
  name : Option[String] = None,
  containerPort : Int,
  hostPort : Option[Int] = None,
  hostIP : Option[String] = None,
  protocol : Option[String] = None
) {
  def withName(value: String) : ContainerPort = copy(name = Some(value))
  def withContainerPort(value: Int) : ContainerPort = copy(containerPort = value)
  def withHostPort(value: Int) : ContainerPort = copy(hostPort = Some(value))
  def withHostIP(value: String) : ContainerPort = copy(hostIP = Some(value))
  def withProtocol(value: String) : ContainerPort = copy(protocol = Some(value))
}

