package io.k8s.api.core.v1


/** Describe a container image */
final case class ContainerImage(
  names : Option[Seq[String]] = None,
  sizeBytes : Option[Int] = None
) {
  def withNames(value: Seq[String]) : ContainerImage = copy(names = Some(value))
  def addNames(newValues: String*) : ContainerImage = copy(names = Some(names.fold(newValues)(_ ++ newValues)))

  def withSizeBytes(value: Int) : ContainerImage = copy(sizeBytes = Some(value))
}

