package io.k8s.api.core.v1


/** Adapts a ConfigMap into a volume.

The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. ConfigMap volumes support ownership management and SELinux relabeling. */
final case class ConfigMapVolumeSource(
  defaultMode : Option[Int] = None,
  items : Option[Seq[io.k8s.api.core.v1.KeyToPath]] = None,
  name : Option[String] = None,
  optional : Option[Boolean] = None
) {
  def withDefaultMode(value: Int) : ConfigMapVolumeSource = copy(defaultMode = Some(value))
  def withItems(value: Seq[io.k8s.api.core.v1.KeyToPath]) : ConfigMapVolumeSource = copy(items = Some(value))
  def addItems(newValues: io.k8s.api.core.v1.KeyToPath*) : ConfigMapVolumeSource = copy(items = Some(items.fold(newValues)(_ ++ newValues)))

  def withName(value: String) : ConfigMapVolumeSource = copy(name = Some(value))
  def withOptional(value: Boolean) : ConfigMapVolumeSource = copy(optional = Some(value))
}

