package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** ConfigMapList is a resource containing a list of ConfigMap objects. */
final case class ConfigMapList(
  items : Seq[io.k8s.api.core.v1.ConfigMap],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ConfigMapList", "v1")

  def withItems(value: Seq[io.k8s.api.core.v1.ConfigMap]) : ConfigMapList = copy(items = value)
  def addItems(newValues: io.k8s.api.core.v1.ConfigMap*) : ConfigMapList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ConfigMapList = copy(metadata = Some(value))
}

