package io.k8s.api.core.v1


/** Selects a key from a ConfigMap. */
final case class ConfigMapKeySelector(
  key : String,
  name : Option[String] = None,
  optional : Option[Boolean] = None
) {
  def withKey(value: String) : ConfigMapKeySelector = copy(key = value)
  def withName(value: String) : ConfigMapKeySelector = copy(name = Some(value))
  def withOptional(value: Boolean) : ConfigMapKeySelector = copy(optional = Some(value))
}

