package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** ConfigMap holds configuration data for pods to consume. */
final case class ConfigMap(
  data : Option[Map[String, String]] = None,
  immutable : Option[Boolean] = None,
  binaryData : Option[Map[String, String]] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ConfigMap", "v1")

  def withData(value: Map[String, String]) : ConfigMap = copy(data = Some(value))
  def addData(newValues: (String, String)*) : ConfigMap = copy(data = Some(data.fold(newValues.toMap)(_ ++ newValues)))

  def withImmutable(value: Boolean) : ConfigMap = copy(immutable = Some(value))
  def withBinaryData(value: Map[String, String]) : ConfigMap = copy(binaryData = Some(value))
  def addBinaryData(newValues: (String, String)*) : ConfigMap = copy(binaryData = Some(binaryData.fold(newValues.toMap)(_ ++ newValues)))

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ConfigMap = copy(metadata = Some(value))
}

