package io.k8s.api.core.v1


/** Information about the condition of a component. */
final case class ComponentCondition(
  error : Option[String] = None,
  message : Option[String] = None,
  status : String,
  `type` : String
) {
  def withError(value: String) : ComponentCondition = copy(error = Some(value))
  def withMessage(value: String) : ComponentCondition = copy(message = Some(value))
  def withStatus(value: String) : ComponentCondition = copy(status = value)
  def withType(value: String) : ComponentCondition = copy(`type` = value)
}

