package io.k8s.api.core.v1


/** Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling. */
final case class CinderVolumeSource(
  fsType : Option[String] = None,
  readOnly : Option[Boolean] = None,
  secretRef : Option[io.k8s.api.core.v1.LocalObjectReference] = None,
  volumeID : String
) {
  def withFsType(value: String) : CinderVolumeSource = copy(fsType = Some(value))
  def withReadOnly(value: Boolean) : CinderVolumeSource = copy(readOnly = Some(value))
  def withSecretRef(value: io.k8s.api.core.v1.LocalObjectReference) : CinderVolumeSource = copy(secretRef = Some(value))
  def withVolumeID(value: String) : CinderVolumeSource = copy(volumeID = value)
}

