package io.k8s.api.core.v1


/** Adds and removes POSIX capabilities from running containers. */
final case class Capabilities(
  add : Option[Seq[String]] = None,
  drop : Option[Seq[String]] = None
) {
  def withAdd(value: Seq[String]) : Capabilities = copy(add = Some(value))
  def addAdd(newValues: String*) : Capabilities = copy(add = Some(add.fold(newValues)(_ ++ newValues)))

  def withDrop(value: Seq[String]) : Capabilities = copy(drop = Some(value))
  def addDrop(newValues: String*) : Capabilities = copy(drop = Some(drop.fold(newValues)(_ ++ newValues)))

}

