package io.k8s.api.core.v1


/** Represents a source location of a volume to mount, managed by an external CSI driver */
final case class CSIVolumeSource(
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  driver : String,
  volumeAttributes : Option[Map[String, String]] = None,
  nodePublishSecretRef : Option[io.k8s.api.core.v1.LocalObjectReference] = None
) {
  def withReadOnly(value: Boolean) : CSIVolumeSource = copy(readOnly = Some(value))
  def withFsType(value: String) : CSIVolumeSource = copy(fsType = Some(value))
  def withDriver(value: String) : CSIVolumeSource = copy(driver = value)
  def withVolumeAttributes(value: Map[String, String]) : CSIVolumeSource = copy(volumeAttributes = Some(value))
  def addVolumeAttributes(newValues: (String, String)*) : CSIVolumeSource = copy(volumeAttributes = Some(volumeAttributes.fold(newValues.toMap)(_ ++ newValues)))

  def withNodePublishSecretRef(value: io.k8s.api.core.v1.LocalObjectReference) : CSIVolumeSource = copy(nodePublishSecretRef = Some(value))
}

