package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** Binding ties one object to another; for example, a pod is bound to a node by a scheduler. Deprecated in 1.7, please use the bindings subresource of pods instead. */
final case class Binding(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  target : io.k8s.api.core.v1.ObjectReference
) extends KObject {
  protected val _resourceKind = ResourceKind("", "Binding", "v1")

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Binding = copy(metadata = Some(value))
  def withTarget(value: io.k8s.api.core.v1.ObjectReference) : Binding = copy(target = value)
}

